<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');
require_once('source/restrict_admin.php');

// Fetch available exams from tbl_exam
$stmt_exams = $DBH->query("SELECT * FROM tbl_exam");
$exams = $stmt_exams->fetchAll(PDO::FETCH_ASSOC);

// Fetch available sessions from tbl_session
$stmt_sessions = $DBH->query("SELECT * FROM tbl_session");
$sessions = $stmt_sessions->fetchAll(PDO::FETCH_ASSOC);

// Fetch available classes from tbl_class
$stmt_classes = $DBH->query("SELECT * FROM tbl_class");
$classes = $stmt_classes->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $exam_id = $_POST['exam_id'];
    $class = $_POST['class'];
    $term = $_POST['term'];
    $session = $_POST['session'];

    try {
        // Check if the combination of exam_id, class, term, and session already exists
        $stmt = $DBH->prepare("SELECT id FROM tbl_exam_class WHERE exam_id = :exam_id AND class = :class AND term = :term AND session = :session");
        $stmt->execute([
            'exam_id' => $exam_id,
            'class' => $class,
            'term' => $term,
            'session' => $session
        ]);
        $existing_combination = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($existing_combination) {
            $error = "This exam is already linked to the selected class, term, and session.";
        } else {
            // Insert into tbl_exam_class
            $stmt = $DBH->prepare("INSERT INTO tbl_exam_class (exam_id, class, term, session) VALUES (:exam_id, :class, :term, :session)");
            $stmt->execute([
                'exam_id' => $exam_id,
                'class' => $class,
                'term' => $term,
                'session' => $session
            ]);

            $success = "Exam successfully linked to class, term, and session.";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}

// Fetch all exam-class combinations to display in a table
$stmt_exam_classes = $DBH->query("
    SELECT ec.id, e.exam_name, ec.class, ec.term, ec.session 
    FROM tbl_exam_class ec
    JOIN tbl_exam e ON ec.exam_id = e.id
");
$exam_classes = $stmt_exam_classes->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Link Exam to Class - CBT Portal</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Link Exam to Class</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger"><?php echo $error; ?></div>
                        <?php endif; ?>
                        <?php if (isset($success)): ?>
                            <div class="alert alert-success"><?php echo $success; ?></div>
                        <?php endif; ?>

                        <!-- Form to link exam to class, term, and session -->
                        <form method="POST">
                            <div class="form-group">
                                <label for="exam_id">Select Exam</label>
                                <select name="exam_id" class="form-control" required>
                                    <option value="">-- Select Exam --</option>
                                    <?php foreach ($exams as $exam): ?>
                                        <option value="<?php echo $exam['id']; ?>">
                                            <?php echo $exam['exam_name']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="class">Select Class</label>
                                <select name="class" class="form-control" required>
                                    <option value="">-- Select Class --</option>
                                    <?php foreach ($classes as $class): ?>
                                        <option value="<?php echo $class['class']; ?>">
                                            <?php echo $class['class']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="term">Select Term</label>
                                <select name="term" class="form-control" required>
                                    <option value="First Term">First Term</option>
                                    <option value="Second Term">Second Term</option>
                                    <option value="Third Term">Third Term</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="session">Select Session</label>
                                <select name="session" class="form-control" required>
                                    <option value="">-- Select Session --</option>
                                    <?php foreach ($sessions as $session): ?>
                                        <option value="<?php echo $session['session']; ?>">
                                            <?php echo $session['session']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Link Exam</button>
                        </form>

                        <!-- Table to display existing exam-class combinations -->
                        <h4 class="mt-5">Existing Exam-Class Combinations</h4>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Exam Name</th>
                                    <th>Class</th>
                                    <th>Term</th>
                                    <th>Session</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($exam_classes as $ec): ?>
                                    <tr>
                                        <td><?php echo $ec['exam_name']; ?></td>
                                        <td><?php echo $ec['class']; ?></td>
                                        <td><?php echo $ec['term']; ?></td>
                                        <td><?php echo $ec['session']; ?></td>
                                        <td>
                                            <a href="set_questions.php?exam_class_id=<?php echo $ec['id']; ?>" class="btn btn-sm btn-success">Set Questions</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>