<?php
require_once('source/session.php');
require_once('source/error.php');
require_once('source/dbconfig.php');
require_once('source/function.php');

if($SESS_FULLNAME_USER){
    $msg = "Welcome, $SESS_FULLNAME_USER!";
}
else if($_SESSION['msg'] == "activated"){
    $msg = "Email Verification is Successful!<br>Sign in to Your Dashboard";
}
else if($_GET['msg'] == "inactive"){
    $msg = "Are you a new member? Check your email to activate your account Now! For a blocked participant, write to support.";
}

if($_SESSION['msg'] == "duplicate") {
    $msg = "Email already registered, please try another.";
}            
else if($_SESSION['msg'] == "signup") {
    $msg = "Account Registered successfully.";
}            
else if($_SESSION['msg'] == "captcha") {
    $msg = "Incorrect Captcha.";
}            
else if($_SESSION['msg'] == "samp") {
    $msg = "Samp request found, please try again.";
}            
else if($_SESSION['msg'] == "failed") {
    $msg = "Invalid Email Password Combination.";
}            
else if($_SESSION['msg'] == "forget") {
    $msg = "New password has been sent to your verified email.";
}            
unset($_SESSION['msg']);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Admin Login | VERBUM DEI INT'L COLLEGE -Powered by DataSwift Coders</title>
    <link rel="icon" type="image/png" href="https://portal.vda.com.ng/coll_admin/coll_logo.jpg">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #1976d2;
            --dark-blue: #0d47a1;
            --light-blue: #64b5f6;
            --accent-blue: #bbdefb;
            --bg-light: #e3f2fd;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: #333;
        }
        
        .login-container {
            max-width: 500px;
            margin: 0 auto;
            animation: fadeIn 0.5s ease-in-out;
        }
        
        .login-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            transition: transform 0.3s ease;
        }
        
        .login-card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background-color: var(--dark-blue);
            color: white;
            padding: 1.5rem;
            text-align: center;
            font-weight: 600;
            font-size: 1.25rem;
        }
        
        .card-body {
            padding: 2rem;
            background-color: white;
        }
        
        .form-control {
            height: 50px;
            border-radius: 8px;
            border: 1px solid #ddd;
            padding-left: 45px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--light-blue);
            box-shadow: 0 0 0 0.2rem rgba(25, 118, 210, 0.25);
        }
        
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-blue);
        }
        
        .btn-login {
            background-color: var(--primary-blue);
            border: none;
            color: white;
            padding: 12px 0;
            font-weight: 600;
            border-radius: 8px;
            transition: all 0.3s;
            width: 100%;
        }
        
        .btn-login:hover {
            background-color: var(--dark-blue);
        }
        
        .school-logo {
            width: 120px;
            height: auto;
            margin-bottom: 1.5rem;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.1));
        }
        
        .powered-by {
            color: white;
            text-align: center;
            margin-top: 2rem;
            font-size: 0.9rem;
        }
        
        .powered-by a {
            color: white;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .powered-by a:hover {
            color: var(--accent-blue);
        }
        
        .powered-by img {
            height: 30px;
            margin-left: 10px;
            vertical-align: middle;
        }
        
        .message-alert {
            margin-bottom: 1.5rem;
            border-radius: 8px;
            text-align: center;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .form-group {
            position: relative;
            margin-bottom: 1.5rem;
        }
    </style>
</head>

<body>
    <div class="container login-container">
        <div class="text-center mb-4">
            <img src="https://portal.vda.com.ng/coll_admin/coll_logo.jpg" alt="VERBUM DEI INT'L COLLEGE" class="school-logo">
        </div>
        
        <div class="login-card">
            <div class="card-header">
                ADMIN PORTAL - VERBUM DEI INT'L COLLEGE
            </div>
            
            <div class="card-body">
                <?php if(!empty($msg)): ?>
                    <div class="alert alert-info message-alert">
                        <?php echo $msg; ?>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="exe_signin.php">
                    <div class="form-group">
                        <i class="fas fa-user input-icon"></i>
                        <input type="text" class="form-control" name="username" placeholder="Enter Username" required autofocus>
                    </div>
                    
                    <div class="form-group">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" class="form-control" name="password" placeholder="Enter Password" required>
                    </div>
                    
                    <div class="d-grid gap-2">
                        <button type="submit" name="signin" class="btn btn-login">
                            <i class="fas fa-sign-in-alt me-2"></i> SIGN IN
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="powered-by">
            <div class="mt-3">
                <a href="https://dataswift.com.ng" target="_blank">
                    <span>Proudly powered by</span>
                    <img src="datalogo.png" alt="DataSwift">
                </a>
            </div>
            <div class="mt-2">
                <i class="fas fa-phone-alt me-2"></i> Support: +234 803 292 9756
            </div>
            <div class="mt-3 small">
                &copy; <?php echo date("Y"); ?> VERBUM DEI INT'L COLLEGE. All Rights Reserved.
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Font Awesome -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
</body>
</html>